<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Tracking;

class TrackingController extends Controller
{
    public function all() {
        return view('admin.tracking.all', [
            'trackings' => Tracking::latest()->get(),
        ]);
    }

    public function single(Tracking $tracking) {
        return view('admin.tracking.single', [
            'tracking' => $tracking,
            'shipment' => $tracking->shipment,
        ]);
    }

    public function delete(Tracking $tracking) {
        $tracking->delete();

        $success_message = 'Tracking and associated shipment deleted successfully.';
        session()->flash('success', $success_message);
        return response()->json(['success' => $success_message]);
    }

    public function edit(Tracking $tracking) {
        return view('admin.tracking.edit', [
            'tracking' => $tracking,
            'shipment' => $tracking->shipment,
        ]);
    }
}
