<?php

namespace App\Livewire\Forms;

use Livewire\Attributes\Validate;
use Livewire\Form;

class ConfigForm extends Form
{
    #[Validate('required|max:255')]
    public $driver;

    #[Validate('required')]
    public $host;

    #[Validate('required|numeric')]
    public $port;

    #[Validate('required')]
    public $encryption;

    #[Validate('required|max:255|email')]
    public $username;

    #[Validate('sometimes')]
    public $password;

    public function set($config) {
        $this->driver = $config->driver;
        $this->host = $config->host;
        $this->port = $config->port;
        $this->encryption = $config->encryption;
        $this->username = $config->username;
        //$this->password = $config->password;
    }
}