<?php

namespace App\Livewire\Forms;

use App\Models\Setting;
use Livewire\Attributes\Validate;
use Livewire\Form;

class SettingsForm extends Form
{
    #[Validate('required|max:255')]
    public $site_name;

    #[Validate('required|url|max:255')]
    public $site_url;

    #[Validate('required|max:255')]
    public $site_domain;

    #[Validate('required|email|max:255')]
    public $site_email;

    #[Validate('required|max:255')]
    public $site_address;

    #[Validate('required|max:255')]
    public $site_phone;
    
    
    public $site_logo;
    public $site_alt_logo;
    public $site_favicon;

    #[Validate('required|max:255')]
    public $currency;

    #[Validate('required|max:255')]
    public $weight_unit;

    public $live_chat;

    public $updated = true;

    public function set(Setting $settings = null) {
        $this->site_name = $settings->site_name;
        $this->site_url = $settings->site_url ?? asset('');
        $this->site_domain = $settings->site_domain ?? request()->getHttpHost();
        $this->site_email = $settings->site_email ?? 'support@'.request()->getHttpHost();
        $this->site_address = $settings->site_address;
        $this->site_phone = $settings->site_phone;

        $this->site_logo = $settings->site_logo;
        $this->site_alt_logo = $settings->site_alt_logo;
        $this->site_favicon = $settings->site_favicon;

        $this->currency = $settings->currency ?? '$';
        $this->weight_unit = $settings->weight_unit ?? 'KG';
        $this->live_chat = $settings->live_chat;
    }
}
