<?php

namespace App\Livewire\Forms;

use App\Models\Shipment;
use Livewire\Attributes\Validate;
use Livewire\Form;

class ShipmentForm extends Form
{
    #[Validate('required|max:255')]
    public $sender_name;

    #[Validate('required|max:255')]
    public $sender_email;

    #[Validate('required|max:255')]
    public $sender_country;

    #[Validate('required|max:255')]
    public $sender_address;

    #[Validate('required|max:255')]
    public $sender_phone;

    #[Validate('required|max:255')]
    public $receiver_name;

    #[Validate('required|max:255')]
    public $receiver_email;

    #[Validate('required|max:255')]
    public $receiver_country;

    #[Validate('required|max:255')]
    public $receiver_address;

    #[Validate('required|max:255')]
    public $receiver_phone;

    public $amount;

    #[Validate('required|max:255')]
    public $description;

    public $photo;

    #[Validate('required|max:255')]
    public $weight;
    
    public $tracking_code;

    public $is_active = true;

    public function setShipmentForm(Shipment $shipment) {
        $this->sender_name = $shipment->sender_name;
        $this->sender_country = $shipment->sender_country;
        $this->sender_address = $shipment->sender_address;
        $this->sender_email = $shipment->sender_email;
        $this->sender_phone = $shipment->sender_phone;

        $this->receiver_name = $shipment->receiver_name;
        $this->receiver_country = $shipment->receiver_country;
        $this->receiver_address = $shipment->receiver_address;
        $this->receiver_email = $shipment->receiver_email;
        $this->receiver_phone = $shipment->receiver_phone;

        $this->amount = $shipment->amount;
        $this->weight = $shipment->weight;
        $this->description = $shipment->description;
        $this->sender_email = $shipment->sender_email;
        $this->photo = $shipment->photo;

        $this->tracking_code = $shipment->tracking_code;
        $this->is_active = $shipment->is_active;
    }
    
}
