<?php

namespace App\Livewire\Shipment;

use Livewire\Component;
use App\Models\Shipment;
use Livewire\WithFileUploads;
use App\Livewire\Forms\ShipmentForm;
use App\Mail\Admin\ShipmentUpdated;
use Illuminate\Support\Facades\Mail;

class Edit extends Component
{
    use WithFileUploads;

    public Shipment $shipment;
    public ShipmentForm $shipment_form;

    public function mount() {
        $this->shipment_form->setShipmentForm($this->shipment);
    }

    public function render() {
        return view('livewire.shipment.edit');
    }

    public function hasChangedPhoto() {
        return $this->shipment_form->photo!=$this->shipment->photo || $this->shipment_form->photo != null;
    }

    public function rules() {
        return [
            'shipment_form.photo' => $this->hasChangedPhoto() ? 'required|image|max:3072': '',
        ];
    }

    public function validationAttributes() {
        return [
            'shipment_form.photo' => 'photo',
        ];
    }

    public function edit() {
        $this->validate();

        if($this->hasChangedPhoto()) {
            $this->shipment_form->photo =  '/storage/'.$this->shipment_form->photo->store('shipment_photos', 'public');
        }
        
        $this->shipment->update($this->shipment_form->all());

        session()->flash('success', 'Shipment updated successfully.');
        Mail::to($this->shipment->receiver_email)->send(new ShipmentUpdated($this->shipment));
        $this->redirect(route('shipment.single', $this->shipment->tracking_code), true);
    }
}
