<?php
namespace App\Utils;

trait ShipmentFaker {
    public function fillForm() {
        $this->shipment_form->tracking_code = tracking_code();
        $this->shipment_form->sender_name = fake()->name;
        $this->shipment_form->sender_email = fake()->email;
        $this->shipment_form->sender_country = fake()->country;
        $this->shipment_form->sender_address = fake()->address;
        $this->shipment_form->sender_phone = fake()->phoneNumber;
        $this->shipment_form->receiver_name = fake()->name;
        $this->shipment_form->receiver_email = fake()->email;
        $this->shipment_form->receiver_country = fake()->country();
        $this->shipment_form->receiver_address = fake()->address;
        $this->shipment_form->receiver_phone = fake()->phoneNumber;
        $this->shipment_form->amount = fake()->numberBetween(0, 1000);
        $this->shipment_form->description = fake()->sentence;
        $this->shipment_form->weight = fake()->randomFloat(2, 0, 100);

        $this->tracking_form->date_sent = fake()->date;
        $this->tracking_form->date_expected = fake()->date;
        $this->tracking_form->progress = 30;
        $this->tracking_form->current_location = fake()->country;
    }
}