<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Shipment>
 */
class ShipmentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'admin_id' => 1,
            'sender_name' => fake()->name,
            'sender_email' => fake()->unique()->safeEmail,
            'sender_country' => fake()->country,
            'sender_address' => fake()->address,
            'sender_phone' => fake()->phoneNumber,
            'receiver_name' => fake()->name,
            'receiver_email' => fake()->unique()->safeEmail,
            'receiver_country' => fake()->country,
            'receiver_address' => fake()->address,
            'receiver_phone' => fake()->phoneNumber,
            'amount' => fake()->randomNumber(4),
            'description' => fake()->sentence,
            'weight' => fake()->randomNumber(2),
            'photo' => fake()->imageUrl(640, 480),
            'is_active' => 1,
            'tracking_code' => tracking_code(),
        ];
    }
}
