<x-layouts.dashboard title="Contact Messages">
    <x-widgets.page-header title="Contact Messages" />

    <div class="card">
        <div class="card-body">
            <table class="table table-bordered" id="messages-table">
                <thead>
                    <tr>
                        <th>S/N</th>
                        <th class="fw-bold">Name</th>
                        <th>Email</th>
                        <th>Subject</th>
                        <th>Phone</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($contacts as $contact)
                        <tr>
                            <td>{{ $id++ }}</td>
                            <td> {{ $contact->name }} </td>
                            <td> {{ $contact->email }} </td>
                            <td> {{ $contact->subject }} </td>
                            <td> {{ $contact->phone }} </td>
                            <td class="text-end">
                                <a wire:navigate href="{{ route('contact-message.single', $contact->id) }}" class="btn btn-primary"><i class="feather icon-eye"></i></a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <script>
        $('#messages-table').DataTable({
            columnDefs: [{
                targets: [5],
                orderable: false
            }]
        });
    </script>
        @if (session('success'))
        <script>
            toast.success(@js(session('success')))
        </script>
    @endif
</x-layouts.dashboard>