@props(['name', 'type' => 'text'])
<input class="form-control @error($name) error-password @enderror" type="password" {{ $attributes }} />

<i @error($name)style="top: 35% !important" @enderror
    class="position-absolute suffix-icon feather cursor-pointer text-dark" :class="showing ? 'icon-eye-off' : 'icon-eye'"
    @click="toggle($refs.password)"></i>

@error($name)
    <div class="invalid-password">
        {{ $message }}
    </div>
@enderror

<style>
    .error-password {
        border: 2px solid #f46363;
    }

    .error-password:active {
        border: 2px solid #f46363;
        box-shadow: 0 0 0 .2rem rgba(244, 99, 99, 0.25) !important;
    }

    .error-password:focus {
        border: 2px solid #f46363;
        box-shadow: 0 0 0 .2rem rgba(244, 99, 99, 0.25) !important;
    }
</style>
