@props(['addon', 'position', 'name'])
<div class="input-group mb-3" {{ $attributes->whereDoesntStartWith('wire:model') }}>

    @if ($position == 'left')
        <div class="input-group-prepend">
            <span class="input-group-text">{{ $addon }}</span>
        </div>
        <x-form.input name="{{ $name }}" {{ $attributes->whereStartsWith('wire:model') }}/>
    @endif

    @if ($position == 'right')
        <input class="form-control @error($name) is-invalid @enderror" type="text" {{ $attributes->whereStartsWith('wire:model') }}/>
        <div class="input-group-prepend">
            <span class="input-group-text">{{ $addon }}</span>
        </div>
        @error($name)
            <div class="invalid-feedback">
                {{ $message }}
            </div>
        @enderror
    @endif
</div>
