<form wire:submit.prevent="edit" x-data="{ status_code: @entangle('status_code').live }">
    <div class="row mt-4">
        <h5 class="lead">Tracking Information</h5>
        @include('partials.tracking-details')
    </div>

    <div class="row mt-3">
        <div class="col-md-6">
            <label class="fw-bold">Tracking Status</label>
            <x-form.select name="status" wire:model="status_code">
                <option value="1">Order Placed</option>
                <option value="2">Processing</option>
                <option value="3">Shipped</option>
                <option value="4">Delivered</option>
                <option value="5">Picked up</option>
                <option value="0">Held</option>
            </x-form.select>
        </div>

        <div class="col-md-6" x-show="status_code=='0'" x-cloak
        x-transition:enter="animate__animated animate__fadeIn"
        x-transition:leave="animate__animated animate__fadeOut"
        >
            <label class="fw-bold">Held Reason</label>
            <x-form.input name="hold_reason" wire:model="hold_reason" />
        </div>
    </div>

    <div class="row mt-4">
        <x-form.submit target="edit" text="Edit Tracking" />
    </div>
</form>
