<x-layout.pages title="Tracking Details #{{ $shipment->tracking_code }}">
  <!--Start Page Header-->
    <section class="page-header">
        <div class="page-header__bg" style="background-image: url(/home-assets/img/bg/breadcrumb_bg.jpg)">
        </div>
        <div class="page-header__pattern">
            <img src="/asset/images/pattern/page-header-pattern.png" alt="">
        </div>
        <div class="container">
            <div class="page-header__inner">
                <h2>Tracking</h2>
                <ul class="thm-breadcrumb">
                    <li><a href="/">Home</a></li>
                    <li><span class="icon-right-arrow21"></span></li>
                    <li>Tracking</li>
                </ul>
            </div>
        </div>
    </section>
    <!--End Page Header-->
  <style>
    body {
      font-family: 'Montserrat', sans-serif;
      background: #f6f6f6;
    }

    .progress {
      padding: 6px;
      background: rgba(0, 0, 0, 0.25);
      border-radius: 6px;
      box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.25), 0 1px rgba(255, 255, 255, 0.08);
    }

    .progress-bar {
      height: 18px;
      background-color: #ee303c;
      border-radius: 4px;
      transition: 0.4s linear;
      transition-property: width, background-color;
    }

    .progress-striped .progress-bar {
      background-color: #FCBC51;
      width: 100%;
      background-image: linear-gradient(45deg, rgb(252, 163, 17) 25%,
          transparent 25%, transparent 50%,
          rgb(252, 163, 17) 50%, rgb(252, 163, 17) 75%,
          transparent 75%, transparent);
      animation: progressAnimationStrike 6s;
    }

    @keyframes progressAnimationStrike {
      from {
        width: 0
      }

      to {
        width: 100%
      }
    }

    .progress2 {
      padding: 6px;
      border-radius: 30px;
      background: rgba(0, 0, 0, 0.25);
      box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.25), 0 1px rgba(255, 255, 255, 0.08);
    }

    .progress-bar2 {
      height: 18px;
      border-radius: 30px;
      background-image:
        linear-gradient(to bottom, rgba(255, 255, 255, 0.3), rgba(255, 255, 255, 0.05));
      transition: 0.4s linear;
      transition-property: width, background-color;
    }

    .progress-moved .progress-bar2 {
      width: {{ $tracking->progress }}%;
      background-color: #0d6efd;
      animation: progressAnimation 6s;
    }

    @keyframes progressAnimation {
      0% {
        width: 0%;
        background-color: #F9BCCA;
      }

      100% {
        width: {{ $tracking->progress }}%;
        background-color: #0d6efd;
      }
    }

    .progress-bar3 {
      height: 18px;
      border-radius: 4px;
      background-image:
        linear-gradient(to right,
          #4cd964, #5ac8fa, #007aff,
          #7DC8E8, #7DC8E8, #ff2d55);
      transition: 0.4s linear;
      transition-property: width, background-color;
    }

    .progress-infinite .progress-bar3 {
      width: 100%;
      background-image:
        linear-gradient(to right, #4cd964, #5ac8fa, #007aff, #7DC8E8, #7DC8E8, #ff2d55);
      animation: colorAnimation 1s infinite;
    }

    @keyframes colorAnimation {
      0% {
        background-image:
          linear-gradient(to right, #4cd964, #5ac8fa, #007aff, #7DC8E8, #7DC8E8, #ff2d55);
      }

      20% {
        background-image:
          linear-gradient(to right, #5ac8fa, #007aff, #7DC8E8, #7DC8E8, #ff2d55, #4cd964);
      }

      40% {
        background-image:
          linear-gradient(to right, #007aff, #7DC8E8, #7DC8E8, #ff2d55, #4cd964, #5ac8fa);
      }

      60% {
        background-image:
          linear-gradient(to right, #7DC8E8, #7DC8E8, #ff2d55, #4cd964, #5ac8fa, #007aff);
      }

      100% {
        background-image:
          linear-gradient(to right, #7DC8E8, #ff2d55, #4cd964, #5ac8fa, #007aff, #7DC8E8);
      }
    }
  </style>
  <section>
    <div class="main-content">
      <section class="section">
        <div class="section-body">
          <div class="container invoice">
            <div class="invoice-print">
              <div class="row">
                <div class="col-lg-12">



                  <div class="invoice-title mt-5">
                    <h2>Shipment Invoice</h2>
                    <div class="invoice-number">Shipment Number(Tracking ID): <span class="fw-bold"> {{$shipment->tracking_code }}</span></div>

                  </div>
                  <hr>
                  <div class="row">
                    <div class="col-md-6">
                      <address>
                        <strong>Shipper Information:</strong><br>
                        Name : {{ $shipment->sender_name }}<br>
                        Email : {{ $shipment->sender_email }} <br>
                        Address {{ $shipment->sender_address }} :
                      </address>
                    </div>
                    <div class="col-md-6 text-md-right">
                      <address>
                        <strong>Shipped To:</strong><br>
                        Name : {{ $shipment->receiver_name }}<br>
                        Email : {{ $shipment->receiver_email }} <br>
                        Address {{ $shipment->receiver_address }} :
                      </address>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-6 text-md-left">
                      <address>
                        <strong>Departure Date</strong><br>
                        {{ $tracking->date_sent->format('d/m/Y') }} <br><br>
                      </address>
                    </div>
                    <div class="col-md-6 text-md-right">
                      <address>
                        <strong>Delivery Date</strong><br>
                        {{ $tracking->date_expected->format('d/m/Y') }}<br><br>
                      </address>
                    </div>

                    <div class="col-md-6 text-md-left">
                      <address>
                        <strong>Parcel Statue Progress ({{ $tracking->progress }}%) </strong><br>
                        <div class="container">
                          <div class="progress2 progress-moved">
                            <div class="progress-bar2">
                            </div>
                          </div>
                        </div>
                      </address><br>
                      {{-- <address>
            
                                <strong>Parcel Statue Indicator</strong><br>
                                <div style="margin-top:200px;">
                                    <div class='pin'></div>
                                    <div class='pulse'></div>
                                </div>
                                </address> --}}
                      <address>
                        <h2 ></h2>

                      </address>
                      <form>
                        <input type="hidden" value="" id="progress">
                      </form>
                    </div>
                  </div>

                </div>
              </div>
              <div class="row mt-4">
                <div class="col-md-12">
                  <div class="section-title"><span style="font-weight:bold;">Shipment Summary</span></div>
                  <p class="section-lead">Here are some other important shipment information to take note of.</p>
                  <div class="mt-5">
                    <h5>Shipment Details</h5>
                    <table class="table">
                      <thead>
                        <tr>
                          <th>Item</th>
                          <th>Details</th>
                        </tr>
                      </thead>
                      <tbody>
                        @if($shipment->amount)
                        <tr>
                          <td>Amount</td>
                          <td>{{ $settings->currency . number_format($shipment->amount, 2) }}</td>
                        </tr>
                        @endif

                        <tr>
                          <td>Weight</td>
                          <td>{{ $shipment->weight . $settings->weight_unit }}</td>
                        </tr>

                        <tr>
                          <td>Description</td>
                          <td>{{ $shipment->description }}</td>
                        </tr>

                        <tr>
                          <td>Photo</td>
                          <td>
                            @if ($shipment->photo != null)
                            <a role="button" data-bs-toggle="modal" data-bs-target="#view-photo" class="text-primary text-decoration-underline">
                              <i>Click to view</i>
                            </a>
                            @else
                            <div class="badge bg-info">No photo was uploaded for this shipment.</div>
                            @endif
                          </td>
                        </tr>

                        <tr>
                          <td>Status</td>
                          <td><span
                              @class([ 'badge' , 'bg-success'=> $shipment->is_active,
                              'bg-danger' => !$shipment->is_active,
                              ])>{{ shipment_status($shipment->is_active) }}</span>
                          </td>
                        </tr>

                        <tr>
                          <td>Creation Date</td>
                          <td>{{ $shipment->created_at->format('d/m/Y') }}</td>
                        </tr>

                      </tbody>
                    </table>
                  </div>

                  <div class="mt-5">
                    <h5>Tracking Details</h5>
                    <table class="table">
                      <thead>
                        <tr>
                          <th>Item</th>
                          <th>Details</th>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                          <td>Tracking Status</td>
                          <td>
                            <div
                              class="d-flex align-items-center text-{{ status_class($tracking->status_code) }}">
                              <span
                                class="badge-dot me-2 bg-{{ status_class($tracking->status_code) }}"></span>
                              <span class="text-capitalize">{!! status($tracking->status_code) !!}</span>
                            </div>
                          </td>
                        </tr>

                        @if ($tracking->status_code == 0)
                        <tr>
                          <td>Hold Reason</td>
                          <td>{{ $tracking->hold_reason }} </td>
                        </tr>
                        @endif

                        <tr>
                          <td>Date Sent</td>
                          <td>{{ $tracking->date_sent->format('m/d/Y') }}</td>
                        </tr>

                        <tr>
                          <td>Date Expected</td>
                          <td>{{ $tracking->date_expected->format('m/d/Y') }}</td>
                        </tr>

                        <tr>
                          <td>Progress</td>
                          <td>{{ $tracking->progress }}% </td>
                        </tr>

                        <tr>
                          <td>Current Location</td>
                          <td>{{ $tracking->current_location }} </td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
    </div>
  </section>
  </div>
  <div>
    <iframe width='100%' height='500px' src="https://maps.google.com/maps?q={{ $tracking->current_location }}&output=embed"></iframe>

  </div>
  </section>
  @include('partials.photo-modal')
</x-layout.pages>